/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.server.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ServerGwtSerDer implements GwtSerDer<net.bluemind.server.api.Server> {

	public ServerGwtSerDer( ) {
	}

	@Override
	public net.bluemind.server.api.Server deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.server.api.Server ret = new net.bluemind.server.api.Server();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.server.api.Server ret, JSONObject json) {

		JSONValue ipJSON = json.get("ip");
		ret.ip =  GwtSerDerUtils.STRING.deserialize(ipJSON);
		JSONValue fqdnJSON = json.get("fqdn");
		ret.fqdn =  GwtSerDerUtils.STRING.deserialize(fqdnJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue tagsJSON = json.get("tags");
		ret.tags =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).deserialize(tagsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.server.api.Server o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.server.api.Server o, JSONObject ret) {

		ret.put("ip",  GwtSerDerUtils.STRING.serialize( o.ip ));
		ret.put("fqdn",  GwtSerDerUtils.STRING.serialize( o.fqdn ));
		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("tags",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( o.tags ));
	}
}