/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.server.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AssignmentGwtSerDer implements GwtSerDer<net.bluemind.server.api.Assignment> {

	public AssignmentGwtSerDer( ) {
	}

	@Override
	public net.bluemind.server.api.Assignment deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.server.api.Assignment ret = new net.bluemind.server.api.Assignment();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.server.api.Assignment ret, JSONObject json) {

		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue serverUidJSON = json.get("serverUid");
		ret.serverUid =  GwtSerDerUtils.STRING.deserialize(serverUidJSON);
		JSONValue tagJSON = json.get("tag");
		ret.tag =  GwtSerDerUtils.STRING.deserialize(tagJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.server.api.Assignment o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.server.api.Assignment o, JSONObject ret) {

		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("serverUid",  GwtSerDerUtils.STRING.serialize( o.serverUid ));
		ret.put("tag",  GwtSerDerUtils.STRING.serialize( o.tag ));
	}
}