/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.container.model.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ItemFlagFilterGwtSerDer implements GwtSerDer<net.bluemind.core.container.model.ItemFlagFilter> {

	public ItemFlagFilterGwtSerDer( ) {
	}

	@Override
	public net.bluemind.core.container.model.ItemFlagFilter deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.core.container.model.ItemFlagFilter ret = new net.bluemind.core.container.model.ItemFlagFilter();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.core.container.model.ItemFlagFilter ret, JSONObject json) {

		JSONValue mustJSON = json.get("must");
		ret.must =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).deserialize(mustJSON);
		JSONValue mustNotJSON = json.get("mustNot");
		ret.mustNot =  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).deserialize(mustNotJSON);
		JSONValue skipVersionsJSON = json.get("skipVersions");
		ret.skipVersions =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.LONG).deserialize(skipVersionsJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.core.container.model.ItemFlagFilter o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.core.container.model.ItemFlagFilter o, JSONObject ret) {

		ret.put("must",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).serialize( o.must ));
		ret.put("mustNot",  new GwtSerDerUtils.CollectionSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemFlagGwtSerDer()).serialize( o.mustNot ));
		ret.put("skipVersions",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.LONG).serialize( o.skipVersions ));
	}
}