/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class AccessTokenInfoGwtSerDer implements GwtSerDer<net.bluemind.authentication.api.AccessTokenInfo> {

	public AccessTokenInfoGwtSerDer( ) {
	}

	@Override
	public net.bluemind.authentication.api.AccessTokenInfo deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.authentication.api.AccessTokenInfo ret = new net.bluemind.authentication.api.AccessTokenInfo();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.authentication.api.AccessTokenInfo ret, JSONObject json) {

		JSONValue statusJSON = json.get("status");
		ret.status =  new net.bluemind.authentication.api.gwt.serder.AccessTokenInfoTokenStatusGwtSerDer().deserialize(statusJSON);
		JSONValue externalAuthEndPointUrlJSON = json.get("externalAuthEndPointUrl");
		ret.externalAuthEndPointUrl =  GwtSerDerUtils.STRING.deserialize(externalAuthEndPointUrlJSON);
		JSONValue internalRedirectUrlJSON = json.get("internalRedirectUrl");
		ret.internalRedirectUrl =  GwtSerDerUtils.STRING.deserialize(internalRedirectUrlJSON);
		JSONValue applicationIdJSON = json.get("applicationId");
		ret.applicationId =  GwtSerDerUtils.STRING.deserialize(applicationIdJSON);
		JSONValue stateJSON = json.get("state");
		ret.state =  GwtSerDerUtils.STRING.deserialize(stateJSON);
		JSONValue codeChallengeJSON = json.get("codeChallenge");
		ret.codeChallenge =  GwtSerDerUtils.STRING.deserialize(codeChallengeJSON);
		JSONValue codeChallengeMethodJSON = json.get("codeChallengeMethod");
		ret.codeChallengeMethod =  GwtSerDerUtils.STRING.deserialize(codeChallengeMethodJSON);
		JSONValue responseTypeJSON = json.get("responseType");
		ret.responseType =  GwtSerDerUtils.STRING.deserialize(responseTypeJSON);
		JSONValue scopeJSON = json.get("scope");
		ret.scope =  GwtSerDerUtils.STRING.deserialize(scopeJSON);
		JSONValue urlJSON = json.get("url");
		ret.url =  GwtSerDerUtils.STRING.deserialize(urlJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.authentication.api.AccessTokenInfo o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.authentication.api.AccessTokenInfo o, JSONObject ret) {

		ret.put("status",  new net.bluemind.authentication.api.gwt.serder.AccessTokenInfoTokenStatusGwtSerDer().serialize( o.status ));
		ret.put("externalAuthEndPointUrl",  GwtSerDerUtils.STRING.serialize( o.externalAuthEndPointUrl ));
		ret.put("internalRedirectUrl",  GwtSerDerUtils.STRING.serialize( o.internalRedirectUrl ));
		ret.put("applicationId",  GwtSerDerUtils.STRING.serialize( o.applicationId ));
		ret.put("state",  GwtSerDerUtils.STRING.serialize( o.state ));
		ret.put("codeChallenge",  GwtSerDerUtils.STRING.serialize( o.codeChallenge ));
		ret.put("codeChallengeMethod",  GwtSerDerUtils.STRING.serialize( o.codeChallengeMethod ));
		ret.put("responseType",  GwtSerDerUtils.STRING.serialize( o.responseType ));
		ret.put("scope",  GwtSerDerUtils.STRING.serialize( o.scope ));
		ret.put("url",  GwtSerDerUtils.STRING.serialize( o.url ));
	}
}