/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.authentication.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class SudoSupportGwtEndpoint implements net.bluemind.authentication.api.ISudoSupportAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public SudoSupportGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/auth/sudo_support";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public SudoSupportGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void setOwner(String subject, final AsyncHandler<Void> handler) {
		String postUri = "/_owner";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&subject=" + com.google.gwt.http.client.URL.encodeQueryString(""+subject);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.authentication.api.ISudoSupportPromise promiseApi() {
		return new SudoSupportEndpointPromise(this);
	}
}
