/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementRRuleGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement.RRule> {

	public ICalendarElementRRuleGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement.RRule deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement.RRule ret = new net.bluemind.icalendar.api.ICalendarElement.RRule();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule ret, JSONObject json) {

		JSONValue frequencyJSON = json.get("frequency");
		ret.frequency =  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleFrequencyGwtSerDer().deserialize(frequencyJSON);
		JSONValue countJSON = json.get("count");
		ret.count =  GwtSerDerUtils.INT.deserialize(countJSON);
		JSONValue untilJSON = json.get("until");
		ret.until =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(untilJSON);
		JSONValue intervalJSON = json.get("interval");
		ret.interval =  GwtSerDerUtils.INT.deserialize(intervalJSON);
		JSONValue bySecondJSON = json.get("bySecond");
		ret.bySecond =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(bySecondJSON);
		JSONValue byMinuteJSON = json.get("byMinute");
		ret.byMinute =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMinuteJSON);
		JSONValue byHourJSON = json.get("byHour");
		ret.byHour =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byHourJSON);
		JSONValue byDayJSON = json.get("byDay");
		ret.byDay =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleWeekDayGwtSerDer()).deserialize(byDayJSON);
		JSONValue byMonthDayJSON = json.get("byMonthDay");
		ret.byMonthDay =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMonthDayJSON);
		JSONValue byYearDayJSON = json.get("byYearDay");
		ret.byYearDay =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byYearDayJSON);
		JSONValue byWeekNoJSON = json.get("byWeekNo");
		ret.byWeekNo =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byWeekNoJSON);
		JSONValue byMonthJSON = json.get("byMonth");
		ret.byMonth =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(byMonthJSON);
		JSONValue bySetPosJSON = json.get("bySetPos");
		ret.bySetPos =  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).deserialize(bySetPosJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement.RRule o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.RRule o, JSONObject ret) {

		ret.put("frequency",  new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleFrequencyGwtSerDer().serialize( o.frequency ));
		ret.put("count",  GwtSerDerUtils.INT.serialize( o.count ));
		ret.put("until",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.until ));
		ret.put("interval",  GwtSerDerUtils.INT.serialize( o.interval ));
		ret.put("bySecond",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.bySecond ));
		ret.put("byMinute",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMinute ));
		ret.put("byHour",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byHour ));
		ret.put("byDay",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.icalendar.api.gwt.serder.ICalendarElementRRuleWeekDayGwtSerDer()).serialize( o.byDay ));
		ret.put("byMonthDay",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMonthDay ));
		ret.put("byYearDay",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byYearDay ));
		ret.put("byWeekNo",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byWeekNo ));
		ret.put("byMonth",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.byMonth ));
		ret.put("bySetPos",  new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( o.bySetPos ));
	}
}