/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.icalendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ICalendarElementOrganizerGwtSerDer implements GwtSerDer<net.bluemind.icalendar.api.ICalendarElement.Organizer> {

	public ICalendarElementOrganizerGwtSerDer( ) {
	}

	@Override
	public net.bluemind.icalendar.api.ICalendarElement.Organizer deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.icalendar.api.ICalendarElement.Organizer ret = new net.bluemind.icalendar.api.ICalendarElement.Organizer();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.icalendar.api.ICalendarElement.Organizer ret, JSONObject json) {

		JSONValue uriJSON = json.get("uri");
		ret.uri =  GwtSerDerUtils.STRING.deserialize(uriJSON);
		JSONValue commonNameJSON = json.get("commonName");
		ret.commonName =  GwtSerDerUtils.STRING.deserialize(commonNameJSON);
		JSONValue mailtoJSON = json.get("mailto");
		ret.mailto =  GwtSerDerUtils.STRING.deserialize(mailtoJSON);
		JSONValue dirJSON = json.get("dir");
		ret.dir =  GwtSerDerUtils.STRING.deserialize(dirJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.icalendar.api.ICalendarElement.Organizer o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.icalendar.api.ICalendarElement.Organizer o, JSONObject ret) {

		ret.put("uri",  GwtSerDerUtils.STRING.serialize( o.uri ));
		ret.put("commonName",  GwtSerDerUtils.STRING.serialize( o.commonName ));
		ret.put("mailto",  GwtSerDerUtils.STRING.serialize( o.mailto ));
		ret.put("dir",  GwtSerDerUtils.STRING.serialize( o.dir ));
	}
}