/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementStatus extends JavaScriptObject {

	protected JsICalendarElementStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementStatus NeedsAction()
	/*-{
		return "NeedsAction";
	}-*/;

	public static final native JsICalendarElementStatus Completed()
	/*-{
		return "Completed";
	}-*/;

	public static final native JsICalendarElementStatus InProcess()
	/*-{
		return "InProcess";
	}-*/;

	public static final native JsICalendarElementStatus Cancelled()
	/*-{
		return "Cancelled";
	}-*/;

	public static final native JsICalendarElementStatus Confirmed()
	/*-{
		return "Confirmed";
	}-*/;

	public static final native JsICalendarElementStatus Tentative()
	/*-{
		return "Tentative";
	}-*/;

	public static final JsICalendarElementStatus create(net.bluemind.icalendar.api.ICalendarElement.Status value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NeedsAction:
				return NeedsAction();
			case Completed:
				return Completed();
			case InProcess:
				return InProcess();
			case Cancelled:
				return Cancelled();
			case Confirmed:
				return Confirmed();
			case Tentative:
				return Tentative();
			default:
				return null;
			}
		}
	}
}