/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.icalendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsICalendarElementParticipationStatus extends JavaScriptObject {

	protected JsICalendarElementParticipationStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsICalendarElementParticipationStatus NeedsAction()
	/*-{
		return "NeedsAction";
	}-*/;

	public static final native JsICalendarElementParticipationStatus Accepted()
	/*-{
		return "Accepted";
	}-*/;

	public static final native JsICalendarElementParticipationStatus Declined()
	/*-{
		return "Declined";
	}-*/;

	public static final native JsICalendarElementParticipationStatus Tentative()
	/*-{
		return "Tentative";
	}-*/;

	public static final native JsICalendarElementParticipationStatus Delegated()
	/*-{
		return "Delegated";
	}-*/;

	public static final native JsICalendarElementParticipationStatus Completed()
	/*-{
		return "Completed";
	}-*/;

	public static final JsICalendarElementParticipationStatus create(net.bluemind.icalendar.api.ICalendarElement.ParticipationStatus value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case NeedsAction:
				return NeedsAction();
			case Accepted:
				return Accepted();
			case Declined:
				return Declined();
			case Tentative:
				return Tentative();
			case Delegated:
				return Delegated();
			case Completed:
				return Completed();
			default:
				return null;
			}
		}
	}
}