/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsCertDataCertificateDomainEngine extends JavaScriptObject {

	protected JsCertDataCertificateDomainEngine() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsCertDataCertificateDomainEngine FILE()
	/*-{
		return "FILE";
	}-*/;

	public static final native JsCertDataCertificateDomainEngine LETS_ENCRYPT()
	/*-{
		return "LETS_ENCRYPT";
	}-*/;

	public static final native JsCertDataCertificateDomainEngine DISABLED()
	/*-{
		return "DISABLED";
	}-*/;

	public static final JsCertDataCertificateDomainEngine create(net.bluemind.system.api.CertData.CertificateDomainEngine value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case FILE:
				return FILE();
			case LETS_ENCRYPT:
				return LETS_ENCRYPT();
			case DISABLED:
				return DISABLED();
			default:
				return null;
			}
		}
	}
}