/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.system.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class SecurityMgmtSockJsEndpoint implements net.bluemind.system.api.ISecurityMgmtAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public SecurityMgmtSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/system/security";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public SecurityMgmtSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void updateFirewallRules(final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/_updatefirewallrules";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void generateLetsEncrypt(net.bluemind.system.api.CertData certData, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "/lets_encrypt";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.system.api.gwt.serder.CertDataGwtSerDer().serialize( certData);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void approveLetsEncryptTos(String uid, final AsyncHandler<Void> handler) {
		String postUri = "/lets_encrypt_tos/{uid}";

		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void updateCertificate(net.bluemind.system.api.CertData certData, final AsyncHandler<Void> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.system.api.gwt.serder.CertDataGwtSerDer().serialize( certData);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void getLetsEncryptTos(final AsyncHandler<String> handler) {
		String postUri = "/lets_encrypt_tos";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.system.api.ISecurityMgmtPromise promiseApi() {
		return new SecurityMgmtEndpointPromise(this);
	}

}
