/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.domain.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class DomainSettingsSockJsEndpoint implements net.bluemind.domain.api.IDomainSettingsAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public DomainSettingsSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/domains/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public DomainSettingsSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void set(Map<String,String> settings, final AsyncHandler<Void> handler) {
		String postUri = "/_settings";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( settings);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Void>(handler) {
					@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});

	}


	@Override
	public void get(final AsyncHandler<Map<String,String>> handler) {
		String postUri = "/_settings";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<Map<String,String>>(handler) {
					@Override
			protected Map<String,String> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.domain.api.IDomainSettingsPromise promiseApi() {
		return new DomainSettingsEndpointPromise(this);
	}

}
