/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.resource.api.type.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ResourceTypeDescriptorPropertyGwtSerDer implements GwtSerDer<net.bluemind.resource.api.type.ResourceTypeDescriptor.Property> {

	public ResourceTypeDescriptorPropertyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.resource.api.type.ResourceTypeDescriptor.Property deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.resource.api.type.ResourceTypeDescriptor.Property ret = new net.bluemind.resource.api.type.ResourceTypeDescriptor.Property();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.resource.api.type.ResourceTypeDescriptor.Property ret, JSONObject json) {

		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorPropertyTypeGwtSerDer().deserialize(typeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.resource.api.type.ResourceTypeDescriptor.Property o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.resource.api.type.ResourceTypeDescriptor.Property o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("type",  new net.bluemind.resource.api.type.gwt.serder.ResourceTypeDescriptorPropertyTypeGwtSerDer().serialize( o.type ));
	}
}