/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.resource.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ResourceDescriptorGwtSerDer implements GwtSerDer<net.bluemind.resource.api.ResourceDescriptor> {

    private net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer parent = new  net.bluemind.directory.api.gwt.serder.DirBaseValueGwtSerDer(); 
	public ResourceDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.resource.api.ResourceDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.resource.api.ResourceDescriptor ret = new net.bluemind.resource.api.ResourceDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.resource.api.ResourceDescriptor ret, JSONObject json) {
		parent.deserializeTo( ret, json);

		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue typeIdentifierJSON = json.get("typeIdentifier");
		ret.typeIdentifier =  GwtSerDerUtils.STRING.deserialize(typeIdentifierJSON);
		JSONValue descriptionJSON = json.get("description");
		ret.description =  GwtSerDerUtils.STRING.deserialize(descriptionJSON);
		JSONValue reservationModeJSON = json.get("reservationMode");
		ret.reservationMode =  new net.bluemind.resource.api.gwt.serder.ResourceReservationModeGwtSerDer().deserialize(reservationModeJSON);
		JSONValue propertiesJSON = json.get("properties");
		ret.properties =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.gwt.serder.ResourceDescriptorPropertyValueGwtSerDer()).deserialize(propertiesJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.resource.api.ResourceDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.resource.api.ResourceDescriptor o, JSONObject ret) {
		parent.serializeTo( o, ret);

		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("typeIdentifier",  GwtSerDerUtils.STRING.serialize( o.typeIdentifier ));
		ret.put("description",  GwtSerDerUtils.STRING.serialize( o.description ));
		ret.put("reservationMode",  new net.bluemind.resource.api.gwt.serder.ResourceReservationModeGwtSerDer().serialize( o.reservationMode ));
		ret.put("properties",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.resource.api.gwt.serder.ResourceDescriptorPropertyValueGwtSerDer()).serialize( o.properties ));
	}
}