/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.resource.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsResourceReservationMode extends JavaScriptObject {

	protected JsResourceReservationMode() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsResourceReservationMode OWNER_MANAGED()
	/*-{
		return "OWNER_MANAGED";
	}-*/;

	public static final native JsResourceReservationMode AUTO_ACCEPT()
	/*-{
		return "AUTO_ACCEPT";
	}-*/;

	public static final native JsResourceReservationMode AUTO_ACCEPT_REFUSE()
	/*-{
		return "AUTO_ACCEPT_REFUSE";
	}-*/;

	public static final JsResourceReservationMode create(net.bluemind.resource.api.ResourceReservationMode value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case OWNER_MANAGED:
				return OWNER_MANAGED();
			case AUTO_ACCEPT:
				return AUTO_ACCEPT();
			case AUTO_ACCEPT_REFUSE:
				return AUTO_ACCEPT_REFUSE();
			default:
				return null;
			}
		}
	}
}