/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.device.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class DeviceEndpointPromise implements net.bluemind.device.api.IDevicePromise {

	private net.bluemind.device.api.IDeviceAsync impl;

	public DeviceEndpointPromise(net.bluemind.device.api.IDeviceAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<Void> setPartnership(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setPartnership(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deleteAll() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteAll( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.device.api.Device device  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, device,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>> list() {
		
		CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>>();
		AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>>() {
			public void success(net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> unwipe(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unwipe(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> unsetPartnership(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.unsetPartnership(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> wipe(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.wipe(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> byIdentifier(String identifier  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.device.api.Device> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byIdentifier(identifier,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.device.api.Device device  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, device,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateLastSync(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateLastSync(uid,  handler);
		return ret;
	}

}
