/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class JobRecGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.JobRec> {

	public JobRecGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.JobRec deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.JobRec ret = new net.bluemind.scheduledjob.api.JobRec();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.JobRec ret, JSONObject json) {

		JSONValue cronStringJSON = json.get("cronString");
		ret.cronString =  GwtSerDerUtils.STRING.deserialize(cronStringJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.JobRec o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.JobRec o, JSONObject ret) {

		ret.put("cronString",  GwtSerDerUtils.STRING.serialize( o.cronString ));
	}
}