/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class JobPlanificationGwtSerDer implements GwtSerDer<net.bluemind.scheduledjob.api.JobPlanification> {

	public JobPlanificationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.scheduledjob.api.JobPlanification deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.scheduledjob.api.JobPlanification ret = new net.bluemind.scheduledjob.api.JobPlanification();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.scheduledjob.api.JobPlanification ret, JSONObject json) {

		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.scheduledjob.api.gwt.serder.PlanKindGwtSerDer().deserialize(kindJSON);
		JSONValue recJSON = json.get("rec");
		ret.rec =  new net.bluemind.scheduledjob.api.gwt.serder.JobRecGwtSerDer().deserialize(recJSON);
		JSONValue lastRunJSON = json.get("lastRun");
		ret.lastRun =  GwtSerDerUtils.DATE.deserialize(lastRunJSON);
		JSONValue nextRunJSON = json.get("nextRun");
		ret.nextRun =  GwtSerDerUtils.DATE.deserialize(nextRunJSON);
		JSONValue domainJSON = json.get("domain");
		ret.domain =  GwtSerDerUtils.STRING.deserialize(domainJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.scheduledjob.api.JobPlanification o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.scheduledjob.api.JobPlanification o, JSONObject ret) {

		ret.put("kind",  new net.bluemind.scheduledjob.api.gwt.serder.PlanKindGwtSerDer().serialize( o.kind ));
		ret.put("rec",  new net.bluemind.scheduledjob.api.gwt.serder.JobRecGwtSerDer().serialize( o.rec ));
		ret.put("lastRun",  GwtSerDerUtils.DATE.serialize( o.lastRun ));
		ret.put("nextRun",  GwtSerDerUtils.DATE.serialize( o.nextRun ));
		ret.put("domain",  GwtSerDerUtils.STRING.serialize( o.domain ));
	}
}