/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.scheduledjob.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class JobGwtEndpoint implements net.bluemind.scheduledjob.api.IJobAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public JobGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/scheduledjobs";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public JobGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void cancel(String jobId, String domainName, final AsyncHandler<Void> handler) {
		String postUri = "/_cancel/{jobId}";

		postUri = postUri.replace("{jobId}", ""+jobId);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&domainName=" + com.google.gwt.http.client.URL.encodeQueryString(""+domainName);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void deleteExecutions(List<Integer> executions, final AsyncHandler<Void> handler) {
		String postUri = "/_deleteExecutions";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.INT).serialize( executions);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getLogs(net.bluemind.scheduledjob.api.JobExecution jobExecution, int offset, final AsyncHandler<Set<net.bluemind.scheduledjob.api.LogEntry>> handler) {
		String postUri = "/_logs";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&offset=" + com.google.gwt.http.client.URL.encodeQueryString(""+offset);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobExecutionGwtSerDer().serialize( jobExecution);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Set<net.bluemind.scheduledjob.api.LogEntry>>(handler) {
			@Override
			protected Set<net.bluemind.scheduledjob.api.LogEntry> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.SetSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.LogEntryGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void start(String jobId, String domainName, final AsyncHandler<Void> handler) {
		String postUri = "/_start/{jobId}";

		postUri = postUri.replace("{jobId}", ""+jobId);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&domainName=" + com.google.gwt.http.client.URL.encodeQueryString(""+domainName);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void searchJob(net.bluemind.scheduledjob.api.JobQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job>> handler) {
		String postUri = "/_searchJob";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.Job> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void update(net.bluemind.scheduledjob.api.Job job, final AsyncHandler<Void> handler) {
		String postUri = "/_updateJob";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobGwtSerDer().serialize( job);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void searchExecution(net.bluemind.scheduledjob.api.JobExecutionQuery query, final AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution>> handler) {
		String postUri = "/_searchExecution";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.scheduledjob.api.gwt.serder.JobExecutionQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution>>(handler) {
			@Override
			protected net.bluemind.core.api.ListResult<net.bluemind.scheduledjob.api.JobExecution> handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.api.gwt.serder.ListResultGwtSerDer<>(new net.bluemind.scheduledjob.api.gwt.serder.JobExecutionGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void deleteExecution(int jobExecutionId, final AsyncHandler<Void> handler) {
		String postUri = "/_deleteExecution";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&jobExecutionId=" + com.google.gwt.http.client.URL.encodeQueryString(""+jobExecutionId);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.DELETE, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<Void>(handler) {
			@Override
			protected Void handleResponse(
							JSONValue jsonValue) {
				return null;
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getJobFromId(String jobId, final AsyncHandler<net.bluemind.scheduledjob.api.Job> handler) {
		String postUri = "/_job/{jobId}";

		postUri = postUri.replace("{jobId}", ""+jobId);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.scheduledjob.api.Job>(handler) {
			@Override
			protected net.bluemind.scheduledjob.api.Job handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.scheduledjob.api.gwt.serder.JobGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.scheduledjob.api.IJobPromise promiseApi() {
		return new JobEndpointPromise(this);
	}
}
