/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.directory.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class DirEntryPathGwtEndpoint implements net.bluemind.directory.api.IDirEntryPathAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public DirEntryPathGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/directory/path";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public DirEntryPathGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void getPath(String domain, String uid, net.bluemind.directory.api.BaseDirEntry.Kind kind, final AsyncHandler<String> handler) {
		String postUri = "/{domain}/{uid}";

		postUri = postUri.replace("{domain}", ""+domain);
		postUri = postUri.replace("{uid}", ""+uid);
		String uri_ = baseUri + postUri;

		String queryParams = "?";
		queryParams += "&kind=" + com.google.gwt.http.client.URL.encodeQueryString(""+kind);
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.GET, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.directory.api.IDirEntryPathPromise promiseApi() {
		return new DirEntryPathEndpointPromise(this);
	}
}
