/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardIdentificationGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Identification> {

	public VCardIdentificationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Identification deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Identification ret = new net.bluemind.addressbook.api.VCard.Identification();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Identification ret, JSONObject json) {

		JSONValue formatedNameJSON = json.get("formatedName");
		ret.formatedName =  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationFormatedNameGwtSerDer().deserialize(formatedNameJSON);
		JSONValue nameJSON = json.get("name");
		ret.name =  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationNameGwtSerDer().deserialize(nameJSON);
		JSONValue nicknameJSON = json.get("nickname");
		ret.nickname =  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationNicknameGwtSerDer().deserialize(nicknameJSON);
		JSONValue photoJSON = json.get("photo");
		ret.photo =  GwtSerDerUtils.BOOLEAN.deserialize(photoJSON);
		JSONValue photoBinaryJSON = json.get("photoBinary");
		ret.photoBinary =  new GwtSerDerUtils.ByteArraySerDer().deserialize(photoBinaryJSON);
		JSONValue birthdayJSON = json.get("birthday");
		ret.birthday =  GwtSerDerUtils.DATE.deserialize(birthdayJSON);
		JSONValue anniversaryJSON = json.get("anniversary");
		ret.anniversary =  GwtSerDerUtils.DATE.deserialize(anniversaryJSON);
		JSONValue genderJSON = json.get("gender");
		ret.gender =  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationGenderGwtSerDer().deserialize(genderJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Identification o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Identification o, JSONObject ret) {

		ret.put("formatedName",  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationFormatedNameGwtSerDer().serialize( o.formatedName ));
		ret.put("name",  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationNameGwtSerDer().serialize( o.name ));
		ret.put("nickname",  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationNicknameGwtSerDer().serialize( o.nickname ));
		ret.put("photo",  GwtSerDerUtils.BOOLEAN.serialize( o.photo ));
		ret.put("photoBinary",  new GwtSerDerUtils.ByteArraySerDer().serialize( o.photoBinary ));
		ret.put("birthday",  GwtSerDerUtils.DATE.serialize( o.birthday ));
		ret.put("anniversary",  GwtSerDerUtils.DATE.serialize( o.anniversary ));
		ret.put("gender",  new net.bluemind.addressbook.api.gwt.serder.VCardIdentificationGenderGwtSerDer().serialize( o.gender ));
	}
}