/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class VCardServiceSockJsEndpoint implements net.bluemind.addressbook.api.IVCardServiceAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public VCardServiceSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/addressbooks/vcards/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public VCardServiceSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void exportAll(final AsyncHandler<String> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"GET",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}


	@Override
	public void importCards(String vcard, final AsyncHandler<net.bluemind.core.task.api.TaskRef> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = GwtSerDerUtils.STRING.serialize( vcard);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"PUT",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.core.task.api.TaskRef>(handler) {
					@Override
			protected net.bluemind.core.task.api.TaskRef handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.core.task.api.gwt.serder.TaskRefGwtSerDer().deserialize( jsonValue );
			}
		});

	}


	@Override
	public void exportCards(List<String> uids, final AsyncHandler<String> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.STRING).serialize( uids);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<String>(handler) {
					@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.addressbook.api.IVCardServicePromise promiseApi() {
		return new VCardServiceEndpointPromise(this);
	}

}
