/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ChangePasswordGwtSerDer implements GwtSerDer<net.bluemind.user.api.ChangePassword> {

	public ChangePasswordGwtSerDer( ) {
	}

	@Override
	public net.bluemind.user.api.ChangePassword deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.user.api.ChangePassword ret = new net.bluemind.user.api.ChangePassword();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.user.api.ChangePassword ret, JSONObject json) {

		JSONValue currentPasswordJSON = json.get("currentPassword");
		ret.currentPassword =  GwtSerDerUtils.STRING.deserialize(currentPasswordJSON);
		JSONValue newPasswordJSON = json.get("newPassword");
		ret.newPassword =  GwtSerDerUtils.STRING.deserialize(newPasswordJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.user.api.ChangePassword o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.user.api.ChangePassword o, JSONObject ret) {

		ret.put("currentPassword",  GwtSerDerUtils.STRING.serialize( o.currentPassword ));
		ret.put("newPassword",  GwtSerDerUtils.STRING.serialize( o.newPassword ));
	}
}