/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.user.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class UserEndpointPromise implements net.bluemind.user.api.IUserPromise {

	private net.bluemind.user.api.IUserAsync impl;

	public UserEndpointPromise(net.bluemind.user.api.IUserAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<byte[]> getPhoto(String uid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getPhoto(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> deletePhoto(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deletePhoto(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<byte[]> getIcon(String uid  ) {
		
		CompletableFuture<byte[]> ret = new CompletableFuture<byte[]>();
		AsyncHandler<byte[]> handler = new AsyncHandler<byte[]>() {
			public void success(byte[] value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getIcon(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setPhoto(String uid ,  byte[] arg1  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setPhoto(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setExtId(String uid ,  String arg1  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setExtId(uid, arg1,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> memberOf(String uid  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.group.api.Group>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.memberOf(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> memberOfGroups(String uid  ) {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.memberOfGroups(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setPassword(String uid ,  net.bluemind.user.api.ChangePassword password  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setPassword(uid, password,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<String>> allUids() {
		
		CompletableFuture<List<String>> ret = new CompletableFuture<List<String>>();
		AsyncHandler<List<String>> handler = new AsyncHandler<List<String>>() {
			public void success(List<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.allUids( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.user.api.User user  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, user,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.addressbook.api.VCard> getVCard(String uid  ) {
		
		CompletableFuture<net.bluemind.addressbook.api.VCard> ret = new CompletableFuture<net.bluemind.addressbook.api.VCard>();
		AsyncHandler<net.bluemind.addressbook.api.VCard> handler = new AsyncHandler<net.bluemind.addressbook.api.VCard>() {
			public void success(net.bluemind.addressbook.api.VCard value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getVCard(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> delete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateAccountType(String uid ,  net.bluemind.directory.api.BaseDirEntry.AccountType accountType  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateAccountType(uid, accountType,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getResolvedRoles(String uid  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getResolvedRoles(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> byLogin(String login  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byLogin(login,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> byEmail(String email  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byEmail(email,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.user.api.User user  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, user,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setRoles(String uid ,  Set<String> roles  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setRoles(uid, roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getRoles(String uid  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRoles(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updateVCard(String uid ,  net.bluemind.addressbook.api.VCard userVCard  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updateVCard(uid, userVCard,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> byExtId(String extid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.byExtId(extid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.user.api.User> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Set<String>> getUsersWithRoles(List<String> roles  ) {
		
		CompletableFuture<Set<String>> ret = new CompletableFuture<Set<String>>();
		AsyncHandler<Set<String>> handler = new AsyncHandler<Set<String>>() {
			public void success(Set<String> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getUsersWithRoles(roles,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> createWithExtId(String uid ,  String extid ,  net.bluemind.user.api.User user  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.createWithExtId(uid, extid, user,  handler);
		return ret;
	}

}
