/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SearchQueryHeaderGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.SearchQuery.Header> {

	public SearchQueryHeaderGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.SearchQuery.Header deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.SearchQuery.Header ret = new net.bluemind.backend.mail.api.SearchQuery.Header();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchQuery.Header ret, JSONObject json) {

		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  GwtSerDerUtils.STRING.deserialize(valueJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.SearchQuery.Header o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchQuery.Header o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("value",  GwtSerDerUtils.STRING.serialize( o.value ));
	}
}