/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class SearchQueryGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.SearchQuery> {

	public SearchQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.SearchQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.SearchQuery ret = new net.bluemind.backend.mail.api.SearchQuery();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.SearchQuery ret, JSONObject json) {

		JSONValue searchSessionIdJSON = json.get("searchSessionId");
		ret.searchSessionId =  GwtSerDerUtils.STRING.deserialize(searchSessionIdJSON);
		JSONValue queryJSON = json.get("query");
		ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		JSONValue recordQueryJSON = json.get("recordQuery");
		ret.recordQuery =  GwtSerDerUtils.STRING.deserialize(recordQueryJSON);
		JSONValue messageIdJSON = json.get("messageId");
		ret.messageId =  GwtSerDerUtils.STRING.deserialize(messageIdJSON);
		JSONValue referencesJSON = json.get("references");
		ret.references =  GwtSerDerUtils.STRING.deserialize(referencesJSON);
		JSONValue headerQueryJSON = json.get("headerQuery");
		ret.headerQuery =  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryHeaderQueryGwtSerDer().deserialize(headerQueryJSON);
		JSONValue maxResultsJSON = json.get("maxResults");
		ret.maxResults =  GwtSerDerUtils.LONG.deserialize(maxResultsJSON);
		JSONValue offsetJSON = json.get("offset");
		ret.offset =  GwtSerDerUtils.LONG.deserialize(offsetJSON);
		JSONValue scopeJSON = json.get("scope");
		ret.scope =  new net.bluemind.backend.mail.api.gwt.serder.SearchQuerySearchScopeGwtSerDer().deserialize(scopeJSON);
		JSONValue logicalOperatorJSON = json.get("logicalOperator");
		ret.logicalOperator =  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryLogicalOperatorGwtSerDer().deserialize(logicalOperatorJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.SearchQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.SearchQuery o, JSONObject ret) {

		ret.put("searchSessionId",  GwtSerDerUtils.STRING.serialize( o.searchSessionId ));
		ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		ret.put("recordQuery",  GwtSerDerUtils.STRING.serialize( o.recordQuery ));
		ret.put("messageId",  GwtSerDerUtils.STRING.serialize( o.messageId ));
		ret.put("references",  GwtSerDerUtils.STRING.serialize( o.references ));
		ret.put("headerQuery",  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryHeaderQueryGwtSerDer().serialize( o.headerQuery ));
		ret.put("maxResults",  GwtSerDerUtils.LONG.serialize( o.maxResults ));
		ret.put("offset",  GwtSerDerUtils.LONG.serialize( o.offset ));
		ret.put("scope",  new net.bluemind.backend.mail.api.gwt.serder.SearchQuerySearchScopeGwtSerDer().serialize( o.scope ));
		ret.put("logicalOperator",  new net.bluemind.backend.mail.api.gwt.serder.SearchQueryLogicalOperatorGwtSerDer().serialize( o.logicalOperator ));
	}
}