/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MessageSearchResultGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.MessageSearchResult> {

	public MessageSearchResultGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.MessageSearchResult deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.MessageSearchResult ret = new net.bluemind.backend.mail.api.MessageSearchResult();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.MessageSearchResult ret, JSONObject json) {

		JSONValue containerUidJSON = json.get("containerUid");
		ret.containerUid =  GwtSerDerUtils.STRING.deserialize(containerUidJSON);
		JSONValue itemIdJSON = json.get("itemId");
		ret.itemId =  GwtSerDerUtils.INT.deserialize(itemIdJSON);
		JSONValue subjectJSON = json.get("subject");
		ret.subject =  GwtSerDerUtils.STRING.deserialize(subjectJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue messageClassJSON = json.get("messageClass");
		ret.messageClass =  GwtSerDerUtils.STRING.deserialize(messageClassJSON);
		JSONValue dateJSON = json.get("date");
		ret.date =  GwtSerDerUtils.DATE.deserialize(dateJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().deserialize(fromJSON);
		JSONValue toJSON = json.get("to");
		ret.to =  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().deserialize(toJSON);
		JSONValue seenJSON = json.get("seen");
		ret.seen =  GwtSerDerUtils.BOOLEAN.deserialize(seenJSON);
		JSONValue flaggedJSON = json.get("flagged");
		ret.flagged =  GwtSerDerUtils.BOOLEAN.deserialize(flaggedJSON);
		JSONValue hasAttachmentJSON = json.get("hasAttachment");
		ret.hasAttachment =  GwtSerDerUtils.BOOLEAN.deserialize(hasAttachmentJSON);
		JSONValue previewJSON = json.get("preview");
		ret.preview =  GwtSerDerUtils.STRING.deserialize(previewJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.MessageSearchResult o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.MessageSearchResult o, JSONObject ret) {

		ret.put("containerUid",  GwtSerDerUtils.STRING.serialize( o.containerUid ));
		ret.put("itemId",  GwtSerDerUtils.INT.serialize( o.itemId ));
		ret.put("subject",  GwtSerDerUtils.STRING.serialize( o.subject ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("messageClass",  GwtSerDerUtils.STRING.serialize( o.messageClass ));
		ret.put("date",  GwtSerDerUtils.DATE.serialize( o.date ));
		ret.put("from",  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().serialize( o.from ));
		ret.put("to",  new net.bluemind.backend.mail.api.gwt.serder.MessageSearchResultMboxGwtSerDer().serialize( o.to ));
		ret.put("seen",  GwtSerDerUtils.BOOLEAN.serialize( o.seen ));
		ret.put("flagged",  GwtSerDerUtils.BOOLEAN.serialize( o.flagged ));
		ret.put("hasAttachment",  GwtSerDerUtils.BOOLEAN.serialize( o.hasAttachment ));
		ret.put("preview",  GwtSerDerUtils.STRING.serialize( o.preview ));
	}
}