/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ImportMailboxItemSetGwtSerDer implements GwtSerDer<net.bluemind.backend.mail.api.ImportMailboxItemSet> {

	public ImportMailboxItemSetGwtSerDer( ) {
	}

	@Override
	public net.bluemind.backend.mail.api.ImportMailboxItemSet deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.backend.mail.api.ImportMailboxItemSet ret = new net.bluemind.backend.mail.api.ImportMailboxItemSet();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.backend.mail.api.ImportMailboxItemSet ret, JSONObject json) {

		JSONValue mailboxFolderIdJSON = json.get("mailboxFolderId");
		ret.mailboxFolderId =  GwtSerDerUtils.LONG.deserialize(mailboxFolderIdJSON);
		JSONValue idsJSON = json.get("ids");
		ret.ids =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemSetMailboxItemIdGwtSerDer()).deserialize(idsJSON);
		JSONValue expectedIdsJSON = json.get("expectedIds");
		ret.expectedIds =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemSetMailboxItemIdGwtSerDer()).deserialize(expectedIdsJSON);
		JSONValue deleteFromSourceJSON = json.get("deleteFromSource");
		ret.deleteFromSource =  GwtSerDerUtils.BOOLEAN.deserialize(deleteFromSourceJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.backend.mail.api.ImportMailboxItemSet o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.backend.mail.api.ImportMailboxItemSet o, JSONObject ret) {

		ret.put("mailboxFolderId",  GwtSerDerUtils.LONG.serialize( o.mailboxFolderId ));
		ret.put("ids",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemSetMailboxItemIdGwtSerDer()).serialize( o.ids ));
		ret.put("expectedIds",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.backend.mail.api.gwt.serder.ImportMailboxItemSetMailboxItemIdGwtSerDer()).serialize( o.expectedIds ));
		ret.put("deleteFromSource",  GwtSerDerUtils.BOOLEAN.serialize( o.deleteFromSource ));
	}
}