/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class MailConversationActionsEndpointPromise implements net.bluemind.backend.mail.api.IMailConversationActionsPromise {

	private net.bluemind.backend.mail.api.IMailConversationActionsAsync impl;

	public MailConversationActionsEndpointPromise(net.bluemind.backend.mail.api.IMailConversationActionsAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> importItems(long folderDestinationId ,  net.bluemind.backend.mail.api.flags.ImportMailboxConversationSet mailboxItems  ) {
		
		CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> ret = new CompletableFuture<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>();
		AsyncHandler<net.bluemind.backend.mail.api.ImportMailboxItemsStatus> handler = new AsyncHandler<net.bluemind.backend.mail.api.ImportMailboxItemsStatus>() {
			public void success(net.bluemind.backend.mail.api.ImportMailboxItemsStatus value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.importItems(folderDestinationId, mailboxItems,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>> move(String targetMailboxUid ,  List<String> conversationUids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>>() {
			public void success(List<net.bluemind.core.container.model.ItemIdentifier> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.move(targetMailboxUid, conversationUids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> addFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.addFlag(flagUpdate,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> multipleDeleteById(List<String> conversationUids  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleDeleteById(conversationUids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.api.Ack> deleteFlag(net.bluemind.backend.mail.api.flags.ConversationFlagUpdate flagUpdate  ) {
		
		CompletableFuture<net.bluemind.core.container.api.Ack> ret = new CompletableFuture<net.bluemind.core.container.api.Ack>();
		AsyncHandler<net.bluemind.core.container.api.Ack> handler = new AsyncHandler<net.bluemind.core.container.api.Ack>() {
			public void success(net.bluemind.core.container.api.Ack value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.deleteFlag(flagUpdate,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>> copy(String targetMailboxUid ,  List<String> conversationUids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemIdentifier>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>>() {
			public void success(List<net.bluemind.core.container.model.ItemIdentifier> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.copy(targetMailboxUid, conversationUids,  handler);
		return ret;
	}

}
