/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.backend.mail.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class ItemsTransferGwtEndpoint implements net.bluemind.backend.mail.api.IItemsTransferAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public ItemsTransferGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/mail_items_transfer/{fromMailboxUid}/{toMailboxUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{fromMailboxUid}",pathVars[0]);
				uri_ = uri_.replace("{toMailboxUid}",pathVars[1]);
		
		baseUri = uri_;
	}

	public ItemsTransferGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void move(List<Long> itemIds, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/move";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( itemIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void copy(List<Long> itemIds, final AsyncHandler<List<net.bluemind.core.container.model.ItemIdentifier>> handler) {
		String postUri = "/copy";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new GwtSerDerUtils.ListSerDer<>(GwtSerDerUtils.LONG).serialize( itemIds);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<List<net.bluemind.core.container.model.ItemIdentifier>>(handler) {
			@Override
			protected List<net.bluemind.core.container.model.ItemIdentifier> handleResponse(
							JSONValue jsonValue) {
				return new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemIdentifierGwtSerDer()).deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.backend.mail.api.IItemsTransferPromise promiseApi() {
		return new ItemsTransferEndpointPromise(this);
	}
}
