/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RestorableGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.Restorable> {

	public RestorableGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.Restorable deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.Restorable ret = new net.bluemind.dataprotect.api.Restorable();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.Restorable ret, JSONObject json) {

		JSONValue kindJSON = json.get("kind");
		ret.kind =  new net.bluemind.dataprotect.api.gwt.serder.RestorableKindGwtSerDer().deserialize(kindJSON);
		JSONValue entryUidJSON = json.get("entryUid");
		ret.entryUid =  GwtSerDerUtils.STRING.deserialize(entryUidJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue displayNameJSON = json.get("displayName");
		ret.displayName =  GwtSerDerUtils.STRING.deserialize(displayNameJSON);
		JSONValue datalocationJSON = json.get("datalocation");
		ret.datalocation =  GwtSerDerUtils.STRING.deserialize(datalocationJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.Restorable o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.Restorable o, JSONObject ret) {

		ret.put("kind",  new net.bluemind.dataprotect.api.gwt.serder.RestorableKindGwtSerDer().serialize( o.kind ));
		ret.put("entryUid",  GwtSerDerUtils.STRING.serialize( o.entryUid ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("displayName",  GwtSerDerUtils.STRING.serialize( o.displayName ));
		ret.put("datalocation",  GwtSerDerUtils.STRING.serialize( o.datalocation ));
	}
}