/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class PartGenerationGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.PartGeneration> {

	public PartGenerationGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.PartGeneration deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.PartGeneration ret = new net.bluemind.dataprotect.api.PartGeneration();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.PartGeneration ret, JSONObject json) {

		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.INT.deserialize(idJSON);
		JSONValue generationIdJSON = json.get("generationId");
		ret.generationId =  GwtSerDerUtils.INT.deserialize(generationIdJSON);
		JSONValue beginJSON = json.get("begin");
		ret.begin =  GwtSerDerUtils.DATE.deserialize(beginJSON);
		JSONValue endJSON = json.get("end");
		ret.end =  GwtSerDerUtils.DATE.deserialize(endJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.LONG.deserialize(sizeJSON);
		JSONValue tagJSON = json.get("tag");
		ret.tag =  GwtSerDerUtils.STRING.deserialize(tagJSON);
		JSONValue serverJSON = json.get("server");
		ret.server =  GwtSerDerUtils.STRING.deserialize(serverJSON);
		JSONValue withWarningsJSON = json.get("withWarnings");
		ret.withWarnings =  GwtSerDerUtils.BOOLEAN.deserialize(withWarningsJSON);
		JSONValue withErrorsJSON = json.get("withErrors");
		ret.withErrors =  GwtSerDerUtils.BOOLEAN.deserialize(withErrorsJSON);
		JSONValue validJSON = json.get("valid");
		ret.valid =  new net.bluemind.dataprotect.api.gwt.serder.GenerationStatusGwtSerDer().deserialize(validJSON);
		JSONValue datatypeJSON = json.get("datatype");
		ret.datatype =  GwtSerDerUtils.STRING.deserialize(datatypeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.PartGeneration o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.PartGeneration o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.INT.serialize( o.id ));
		ret.put("generationId",  GwtSerDerUtils.INT.serialize( o.generationId ));
		ret.put("begin",  GwtSerDerUtils.DATE.serialize( o.begin ));
		ret.put("end",  GwtSerDerUtils.DATE.serialize( o.end ));
		ret.put("size",  GwtSerDerUtils.LONG.serialize( o.size ));
		ret.put("tag",  GwtSerDerUtils.STRING.serialize( o.tag ));
		ret.put("server",  GwtSerDerUtils.STRING.serialize( o.server ));
		ret.put("withWarnings",  GwtSerDerUtils.BOOLEAN.serialize( o.withWarnings ));
		ret.put("withErrors",  GwtSerDerUtils.BOOLEAN.serialize( o.withErrors ));
		ret.put("valid",  new net.bluemind.dataprotect.api.gwt.serder.GenerationStatusGwtSerDer().serialize( o.valid ));
		ret.put("datatype",  GwtSerDerUtils.STRING.serialize( o.datatype ));
	}
}