/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class GenerationContentGwtSerDer implements GwtSerDer<net.bluemind.dataprotect.api.GenerationContent> {

	public GenerationContentGwtSerDer( ) {
	}

	@Override
	public net.bluemind.dataprotect.api.GenerationContent deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.dataprotect.api.GenerationContent ret = new net.bluemind.dataprotect.api.GenerationContent();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.dataprotect.api.GenerationContent ret, JSONObject json) {

		JSONValue generationIdJSON = json.get("generationId");
		ret.generationId =  GwtSerDerUtils.INT.deserialize(generationIdJSON);
		JSONValue domainsJSON = json.get("domains");
		ret.domains =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.domain.api.gwt.serder.DomainGwtSerDer())).deserialize(domainsJSON);
		JSONValue entriesJSON = json.get("entries");
		ret.entries =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.directory.api.gwt.serder.DirEntryGwtSerDer())).deserialize(entriesJSON);
		JSONValue capabilitiesJSON = json.get("capabilities");
		ret.capabilities =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.dataprotect.api.gwt.serder.RestoreOperationGwtSerDer()).deserialize(capabilitiesJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.dataprotect.api.GenerationContent o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.dataprotect.api.GenerationContent o, JSONObject ret) {

		ret.put("generationId",  GwtSerDerUtils.INT.serialize( o.generationId ));
		ret.put("domains",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.domain.api.gwt.serder.DomainGwtSerDer())).serialize( o.domains ));
		ret.put("entries",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.core.container.model.gwt.serder.ItemValueGwtSerDer<>(new net.bluemind.directory.api.gwt.serder.DirEntryGwtSerDer())).serialize( o.entries ));
		ret.put("capabilities",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.dataprotect.api.gwt.serder.RestoreOperationGwtSerDer()).serialize( o.capabilities ));
	}
}