/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.dataprotect.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class DataProtectEndpointPromise implements net.bluemind.dataprotect.api.IDataProtectPromise {

	private net.bluemind.dataprotect.api.IDataProtectAsync impl;

	public DataProtectEndpointPromise(net.bluemind.dataprotect.api.IDataProtectAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> saveAll() {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.saveAll( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> getContent(String partGen  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getContent(partGen,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> run(net.bluemind.dataprotect.api.RestoreDefinition restoreDefinition  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.run(restoreDefinition,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.dataprotect.api.RestoreOperation>> getRestoreCapabilitiesByTags(List<String> tags  ) {
		
		CompletableFuture<List<net.bluemind.dataprotect.api.RestoreOperation>> ret = new CompletableFuture<List<net.bluemind.dataprotect.api.RestoreOperation>>();
		AsyncHandler<List<net.bluemind.dataprotect.api.RestoreOperation>> handler = new AsyncHandler<List<net.bluemind.dataprotect.api.RestoreOperation>>() {
			public void success(List<net.bluemind.dataprotect.api.RestoreOperation> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRestoreCapabilitiesByTags(tags,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> installFromGeneration(int generationId  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.installFromGeneration(generationId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.task.api.TaskRef> forget(int generationId  ) {
		
		CompletableFuture<net.bluemind.core.task.api.TaskRef> ret = new CompletableFuture<net.bluemind.core.task.api.TaskRef>();
		AsyncHandler<net.bluemind.core.task.api.TaskRef> handler = new AsyncHandler<net.bluemind.core.task.api.TaskRef>() {
			public void success(net.bluemind.core.task.api.TaskRef value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.forget(generationId,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.dataprotect.api.RestoreOperation>> getRestoreCapabilities() {
		
		CompletableFuture<List<net.bluemind.dataprotect.api.RestoreOperation>> ret = new CompletableFuture<List<net.bluemind.dataprotect.api.RestoreOperation>>();
		AsyncHandler<List<net.bluemind.dataprotect.api.RestoreOperation>> handler = new AsyncHandler<List<net.bluemind.dataprotect.api.RestoreOperation>>() {
			public void success(List<net.bluemind.dataprotect.api.RestoreOperation> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRestoreCapabilities( handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.dataprotect.api.RetentionPolicy> getRetentionPolicy() {
		
		CompletableFuture<net.bluemind.dataprotect.api.RetentionPolicy> ret = new CompletableFuture<net.bluemind.dataprotect.api.RetentionPolicy>();
		AsyncHandler<net.bluemind.dataprotect.api.RetentionPolicy> handler = new AsyncHandler<net.bluemind.dataprotect.api.RetentionPolicy>() {
			public void success(net.bluemind.dataprotect.api.RetentionPolicy value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getRetentionPolicy( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updatePolicy(net.bluemind.dataprotect.api.RetentionPolicy rp  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updatePolicy(rp,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<List<net.bluemind.dataprotect.api.DataProtectGeneration>> getAvailableGenerations() {
		
		CompletableFuture<List<net.bluemind.dataprotect.api.DataProtectGeneration>> ret = new CompletableFuture<List<net.bluemind.dataprotect.api.DataProtectGeneration>>();
		AsyncHandler<List<net.bluemind.dataprotect.api.DataProtectGeneration>> handler = new AsyncHandler<List<net.bluemind.dataprotect.api.DataProtectGeneration>>() {
			public void success(List<net.bluemind.dataprotect.api.DataProtectGeneration> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getAvailableGenerations( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> syncWithFilesystem() {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.syncWithFilesystem( handler);
		return ret;
	}

}
