/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VFreebusySlotGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VFreebusy.Slot> {

	public VFreebusySlotGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VFreebusy.Slot deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VFreebusy.Slot ret = new net.bluemind.calendar.api.VFreebusy.Slot();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VFreebusy.Slot ret, JSONObject json) {

		JSONValue dtstartJSON = json.get("dtstart");
		ret.dtstart =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtstartJSON);
		JSONValue dtendJSON = json.get("dtend");
		ret.dtend =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dtendJSON);
		JSONValue typeJSON = json.get("type");
		ret.type =  new net.bluemind.calendar.api.gwt.serder.VFreebusyTypeGwtSerDer().deserialize(typeJSON);
		JSONValue summaryJSON = json.get("summary");
		ret.summary =  GwtSerDerUtils.STRING.deserialize(summaryJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VFreebusy.Slot o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VFreebusy.Slot o, JSONObject ret) {

		ret.put("dtstart",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtstart ));
		ret.put("dtend",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dtend ));
		ret.put("type",  new net.bluemind.calendar.api.gwt.serder.VFreebusyTypeGwtSerDer().serialize( o.type ));
		ret.put("summary",  GwtSerDerUtils.STRING.serialize( o.summary ));
	}
}