/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventQueryGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventQuery> {

	public VEventQueryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventQuery deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventQuery ret = new net.bluemind.calendar.api.VEventQuery();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventQuery ret, JSONObject json) {

		JSONValue queryJSON = json.get("query");
		ret.query =  GwtSerDerUtils.STRING.deserialize(queryJSON);
		JSONValue fromJSON = json.get("from");
		ret.from =  GwtSerDerUtils.INT.deserialize(fromJSON);
		JSONValue sizeJSON = json.get("size");
		ret.size =  GwtSerDerUtils.INT.deserialize(sizeJSON);
		JSONValue escapeQueryJSON = json.get("escapeQuery");
		ret.escapeQuery =  GwtSerDerUtils.BOOLEAN.deserialize(escapeQueryJSON);
		JSONValue dateMinJSON = json.get("dateMin");
		ret.dateMin =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMinJSON);
		JSONValue dateMaxJSON = json.get("dateMax");
		ret.dateMax =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateMaxJSON);
		JSONValue resolveAttendeesJSON = json.get("resolveAttendees");
		ret.resolveAttendees =  GwtSerDerUtils.BOOLEAN.deserialize(resolveAttendeesJSON);
		JSONValue attendeeJSON = json.get("attendee");
		ret.attendee =  new net.bluemind.calendar.api.gwt.serder.VEventAttendeeQueryGwtSerDer().deserialize(attendeeJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventQuery o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventQuery o, JSONObject ret) {

		ret.put("query",  GwtSerDerUtils.STRING.serialize( o.query ));
		ret.put("from",  GwtSerDerUtils.INT.serialize( o.from ));
		ret.put("size",  GwtSerDerUtils.INT.serialize( o.size ));
		ret.put("escapeQuery",  GwtSerDerUtils.BOOLEAN.serialize( o.escapeQuery ));
		ret.put("dateMin",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMin ));
		ret.put("dateMax",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateMax ));
		ret.put("resolveAttendees",  GwtSerDerUtils.BOOLEAN.serialize( o.resolveAttendees ));
		ret.put("attendee",  new net.bluemind.calendar.api.gwt.serder.VEventAttendeeQueryGwtSerDer().serialize( o.attendee ));
	}
}