/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VEventChangesGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.VEventChanges> {

	public VEventChangesGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.VEventChanges deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.VEventChanges ret = new net.bluemind.calendar.api.VEventChanges();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.VEventChanges ret, JSONObject json) {

		JSONValue addJSON = json.get("add");
		ret.add =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventChangesItemAddGwtSerDer()).deserialize(addJSON);
		JSONValue modifyJSON = json.get("modify");
		ret.modify =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventChangesItemModifyGwtSerDer()).deserialize(modifyJSON);
		JSONValue deleteJSON = json.get("delete");
		ret.delete =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventChangesItemDeleteGwtSerDer()).deserialize(deleteJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.calendar.api.VEventChanges o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.VEventChanges o, JSONObject ret) {

		ret.put("add",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventChangesItemAddGwtSerDer()).serialize( o.add ));
		ret.put("modify",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventChangesItemModifyGwtSerDer()).serialize( o.modify ));
		ret.put("delete",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.VEventChangesItemDeleteGwtSerDer()).serialize( o.delete ));
	}
}