/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class PrintOptionsGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.PrintOptions> {

	public PrintOptionsGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.PrintOptions deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.PrintOptions ret = new net.bluemind.calendar.api.PrintOptions();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.PrintOptions ret, JSONObject json) {

		JSONValue viewJSON = json.get("view");
		ret.view =  new net.bluemind.calendar.api.gwt.serder.PrintOptionsPrintViewGwtSerDer().deserialize(viewJSON);
		JSONValue formatJSON = json.get("format");
		ret.format =  new net.bluemind.calendar.api.gwt.serder.PrintOptionsPrintFormatGwtSerDer().deserialize(formatJSON);
		JSONValue dateBeginJSON = json.get("dateBegin");
		ret.dateBegin =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateBeginJSON);
		JSONValue dateEndJSON = json.get("dateEnd");
		ret.dateEnd =  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().deserialize(dateEndJSON);
		JSONValue colorJSON = json.get("color");
		ret.color =  GwtSerDerUtils.BOOLEAN.deserialize(colorJSON);
		JSONValue showDetailJSON = json.get("showDetail");
		ret.showDetail =  GwtSerDerUtils.BOOLEAN.deserialize(showDetailJSON);
		JSONValue layoutJSON = json.get("layout");
		ret.layout =  new net.bluemind.calendar.api.gwt.serder.PrintOptionsPrintLayoutGwtSerDer().deserialize(layoutJSON);
		JSONValue calendarsJSON = json.get("calendars");
		ret.calendars =  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.PrintOptionsCalendarMetadataGwtSerDer()).deserialize(calendarsJSON);
		JSONValue tagsFilterJSON = json.get("tagsFilter");
		ret.tagsFilter =  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).deserialize(tagsFilterJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.calendar.api.PrintOptions o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.PrintOptions o, JSONObject ret) {

		ret.put("view",  new net.bluemind.calendar.api.gwt.serder.PrintOptionsPrintViewGwtSerDer().serialize( o.view ));
		ret.put("format",  new net.bluemind.calendar.api.gwt.serder.PrintOptionsPrintFormatGwtSerDer().serialize( o.format ));
		ret.put("dateBegin",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateBegin ));
		ret.put("dateEnd",  new net.bluemind.core.api.date.gwt.serder.BmDateTimeGwtSerDer().serialize( o.dateEnd ));
		ret.put("color",  GwtSerDerUtils.BOOLEAN.serialize( o.color ));
		ret.put("showDetail",  GwtSerDerUtils.BOOLEAN.serialize( o.showDetail ));
		ret.put("layout",  new net.bluemind.calendar.api.gwt.serder.PrintOptionsPrintLayoutGwtSerDer().serialize( o.layout ));
		ret.put("calendars",  new GwtSerDerUtils.ListSerDer<>(new net.bluemind.calendar.api.gwt.serder.PrintOptionsCalendarMetadataGwtSerDer()).serialize( o.calendars ));
		ret.put("tagsFilter",  new GwtSerDerUtils.SetSerDer<>(GwtSerDerUtils.STRING).serialize( o.tagsFilter ));
	}
}