/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class CalendarDescriptorGwtSerDer implements GwtSerDer<net.bluemind.calendar.api.CalendarDescriptor> {

	public CalendarDescriptorGwtSerDer( ) {
	}

	@Override
	public net.bluemind.calendar.api.CalendarDescriptor deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.calendar.api.CalendarDescriptor ret = new net.bluemind.calendar.api.CalendarDescriptor();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.calendar.api.CalendarDescriptor ret, JSONObject json) {

		JSONValue nameJSON = json.get("name");
		ret.name =  GwtSerDerUtils.STRING.deserialize(nameJSON);
		JSONValue domainUidJSON = json.get("domainUid");
		ret.domainUid =  GwtSerDerUtils.STRING.deserialize(domainUidJSON);
		JSONValue settingsJSON = json.get("settings");
		ret.settings =  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).deserialize(settingsJSON);
		JSONValue expectedIdJSON = json.get("expectedId");
		ret.expectedId =  GwtSerDerUtils.LONG.deserialize(expectedIdJSON);
		JSONValue ownerJSON = json.get("owner");
		ret.owner =  GwtSerDerUtils.STRING.deserialize(ownerJSON);
		JSONValue orgUnitUidJSON = json.get("orgUnitUid");
		ret.orgUnitUid =  GwtSerDerUtils.STRING.deserialize(orgUnitUidJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.calendar.api.CalendarDescriptor o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.calendar.api.CalendarDescriptor o, JSONObject ret) {

		ret.put("name",  GwtSerDerUtils.STRING.serialize( o.name ));
		ret.put("domainUid",  GwtSerDerUtils.STRING.serialize( o.domainUid ));
		ret.put("settings",  new GwtSerDerUtils.MapSerDer<>(GwtSerDerUtils.STRING,GwtSerDerUtils.STRING).serialize( o.settings ));
		ret.put("expectedId",  GwtSerDerUtils.LONG.serialize( o.expectedId ));
		ret.put("owner",  GwtSerDerUtils.STRING.serialize( o.owner ));
		ret.put("orgUnitUid",  GwtSerDerUtils.STRING.serialize( o.orgUnitUid ));
	}
}