/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.calendar.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsCalendarSettingsDataDay extends JavaScriptObject {

	protected JsCalendarSettingsDataDay() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsCalendarSettingsDataDay SU()
	/*-{
		return "SU";
	}-*/;

	public static final native JsCalendarSettingsDataDay MO()
	/*-{
		return "MO";
	}-*/;

	public static final native JsCalendarSettingsDataDay TU()
	/*-{
		return "TU";
	}-*/;

	public static final native JsCalendarSettingsDataDay WE()
	/*-{
		return "WE";
	}-*/;

	public static final native JsCalendarSettingsDataDay TH()
	/*-{
		return "TH";
	}-*/;

	public static final native JsCalendarSettingsDataDay FR()
	/*-{
		return "FR";
	}-*/;

	public static final native JsCalendarSettingsDataDay SA()
	/*-{
		return "SA";
	}-*/;

	public static final JsCalendarSettingsDataDay create(net.bluemind.calendar.api.CalendarSettingsData.Day value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case SU:
				return SU();
			case MO:
				return MO();
			case TU:
				return TU();
			case WE:
				return WE();
			case TH:
				return TH();
			case FR:
				return FR();
			case SA:
				return SA();
			default:
				return null;
			}
		}
	}
}