/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.json.client.JSONValue;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;

public class VFreebusyGwtEndpoint implements net.bluemind.calendar.api.IVFreebusyAsync {

	private String baseUri;

	private String sessionId;

	private String root = "/api";

	public VFreebusyGwtEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendars/vfreebusy/{containerUid}";
		this.sessionId = sessionId;
	
		uri_ = uri_.replace("{containerUid}",pathVars[0]);
		
		baseUri = uri_;
	}

	public VFreebusyGwtEndpoint withRoot(String root) {
		this.root = root;
		return this;
	}

	@Override
	public void get(net.bluemind.calendar.api.VFreebusyQuery query, final AsyncHandler<net.bluemind.calendar.api.VFreebusy> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.VFreebusyQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<net.bluemind.calendar.api.VFreebusy>(handler) {
			@Override
			protected net.bluemind.calendar.api.VFreebusy handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.calendar.api.gwt.serder.VFreebusyGwtSerDer().deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}


	@Override
	public void getAsString(net.bluemind.calendar.api.VFreebusyQuery query, final AsyncHandler<String> handler) {
		String postUri = "/_ics";

		String uri_ = baseUri + postUri;

		String queryParams = "?";
		uri_ += queryParams;
		String bodyContent = null;
		RequestBuilder builder = new RequestBuilder(RequestBuilder.POST, root + uri_);
		builder.setHeader("X-BM-ApiKey", sessionId);
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.VFreebusyQueryGwtSerDer().serialize( query);
		if( jsonValue != null) {
			bodyContent = jsonValue.toString();
		}

		builder.setHeader("Accept", "application/json");
		builder.setRequestData(bodyContent);
		builder.setCallback( new EndpointRequestCallback<String>(handler) {
			@Override
			protected String handleResponse(
							JSONValue jsonValue) {
				return GwtSerDerUtils.STRING.deserialize( jsonValue);
			}
		});


		try {
			builder.send();
		} catch (RequestException e) {
			handler.failure(e);
		}
	}

	public net.bluemind.calendar.api.IVFreebusyPromise promiseApi() {
		return new VFreebusyEndpointPromise(this);
	}
}
