/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;

public class PrintSockJsEndpoint implements net.bluemind.calendar.api.IPrintAsync {

	private String rootUri = "/api";

	private String baseUri;

    private String sessionId;

	public PrintSockJsEndpoint(String sessionId, String... pathVars) {
		String uri_ = "/calendars/print";
		this.sessionId = sessionId;
	

		baseUri = uri_;
	}

	public PrintSockJsEndpoint withRoot(String root) {
		this.rootUri = root;
		return this;
	}

	@Override
	public void print(net.bluemind.calendar.api.PrintOptions options, final AsyncHandler<net.bluemind.calendar.api.PrintData> handler) {
		String postUri = "";

		String uri_ = baseUri + postUri;

		Map<String,String> params = new java.util.HashMap<>();
		JavaScriptObject bodyContent = null;
		JSONValue jsonValue = new net.bluemind.calendar.api.gwt.serder.PrintOptionsGwtSerDer().serialize( options);
		if( jsonValue != null) {
			bodyContent = jsonValue.isObject().getJavaScriptObject();
		}

		 GwtRestRequest request = net.bluemind.restbus.api.gwt.GwtRestRequest.create(sessionId,"POST",rootUri + uri_,params, bodyContent);
		
		request.getHeaders().put("Accept", "application/json");
		RestBusImpl.get().sendMessage(request, new AsyncHandlerAdapter<net.bluemind.calendar.api.PrintData>(handler) {
					@Override
			protected net.bluemind.calendar.api.PrintData handleResponse(
							JSONValue jsonValue) {
				return new net.bluemind.calendar.api.gwt.serder.PrintDataGwtSerDer().deserialize( jsonValue );
			}
		});

	}

	public net.bluemind.calendar.api.IPrintPromise promiseApi() {
		return new PrintEndpointPromise(this);
	}

}
