/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.calendar.api.gwt.endpoint;

import net.bluemind.core.api.AsyncHandler;
import net.bluemind.core.commons.gwt.EndpointRequestCallback;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.json.client.JSONValue;
import com.google.gwt.json.client.JSONObject;
import net.bluemind.restbus.api.gwt.AsyncHandlerAdapter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.bluemind.core.api.Stream;
import java.lang.Long;
import net.bluemind.restbus.api.gwt.GwtRestRequest;
import net.bluemind.restbus.api.gwt.GwtRestResponse;
import net.bluemind.restbus.api.gwt.RestBusImpl;
import java.util.concurrent.CompletableFuture;

public class CalendarViewEndpointPromise implements net.bluemind.calendar.api.ICalendarViewPromise {

	private net.bluemind.calendar.api.ICalendarViewAsync impl;

	public CalendarViewEndpointPromise(net.bluemind.calendar.api.ICalendarViewAsync impl) {
		this.impl = impl;
	}

	@Override
	public CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>> multipleGet(List<String> uids  ) {
		
		CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>> ret = new CompletableFuture<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>();
		AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>> handler = new AsyncHandler<List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>() {
			public void success(List<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.multipleGet(uids,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> update(String uid ,  net.bluemind.calendar.api.CalendarView view  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.update(uid, view,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>> list() {
		
		CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>> ret = new CompletableFuture<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>();
		AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>> handler = new AsyncHandler<net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>>() {
			public void success(net.bluemind.core.api.ListResult<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.list( handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> updates(net.bluemind.calendar.api.CalendarViewChanges changes  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.updates(changes,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> delete(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.delete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> setDefault(String uid  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.setDefault(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> getComplete(String uid  ) {
		
		CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> ret = new CompletableFuture<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>();
		AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>> handler = new AsyncHandler<net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView>>() {
			public void success(net.bluemind.core.container.model.ItemValue<net.bluemind.calendar.api.CalendarView> value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.getComplete(uid,  handler);
		return ret;
	}


	@Override
	public CompletableFuture<Void> create(String uid ,  net.bluemind.calendar.api.CalendarView view  ) {
		
		CompletableFuture<Void> ret = new CompletableFuture<Void>();
		AsyncHandler<Void> handler = new AsyncHandler<Void>() {
			public void success(Void value) {
				ret.complete(value);
			}
			
			public void failure(Throwable t) {
				ret.completeExceptionally(t);
			}
		};

		this.impl.create(uid, view,  handler);
		return ret;
	}

}
