/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.role.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class RolesCategoryGwtSerDer implements GwtSerDer<net.bluemind.role.api.RolesCategory> {

	public RolesCategoryGwtSerDer( ) {
	}

	@Override
	public net.bluemind.role.api.RolesCategory deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.role.api.RolesCategory ret = new net.bluemind.role.api.RolesCategory();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.role.api.RolesCategory ret, JSONObject json) {

		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.STRING.deserialize(idJSON);
		JSONValue labelJSON = json.get("label");
		ret.label =  GwtSerDerUtils.STRING.deserialize(labelJSON);
		JSONValue priorityJSON = json.get("priority");
		ret.priority =  GwtSerDerUtils.INT.deserialize(priorityJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.role.api.RolesCategory o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.role.api.RolesCategory o, JSONObject ret) {

		ret.put("id",  GwtSerDerUtils.STRING.serialize( o.id ));
		ret.put("label",  GwtSerDerUtils.STRING.serialize( o.label ));
		ret.put("priority",  GwtSerDerUtils.INT.serialize( o.priority ));
	}
}