/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.eas.api.gwt.serder;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class HeartbeatGwtSerDer implements GwtSerDer<net.bluemind.eas.api.Heartbeat> {

	public HeartbeatGwtSerDer( ) {
	}

	@Override
	public net.bluemind.eas.api.Heartbeat deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.eas.api.Heartbeat ret = new net.bluemind.eas.api.Heartbeat();
		deserializeTo(ret, json);

		return ret;
	}

	public void deserializeTo(net.bluemind.eas.api.Heartbeat ret, JSONObject json) {

		JSONValue deviceUidJSON = json.get("deviceUid");
		ret.deviceUid =  GwtSerDerUtils.STRING.deserialize(deviceUidJSON);
		JSONValue valueJSON = json.get("value");
		ret.value =  GwtSerDerUtils.LONG.deserialize(valueJSON);
	}

	@Override
	public JSONValue serialize(net.bluemind.eas.api.Heartbeat o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.eas.api.Heartbeat o, JSONObject ret) {

		ret.put("deviceUid",  GwtSerDerUtils.STRING.serialize( o.deviceUid ));
		ret.put("value",  GwtSerDerUtils.LONG.serialize( o.value ));
	}
}