/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.monitoring.screens;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.resources.client.ClientBundle;
import com.google.gwt.resources.client.CssResource;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.ListBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Arrays;
import java.util.List;
import net.bluemind.core.api.AsyncHandler;
import net.bluemind.gwtconsoleapp.base.editor.ScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtScreenRoot;
import net.bluemind.gwtconsoleapp.base.handler.DefaultAsyncHandler;
import net.bluemind.metrics.alerts.api.AlertInfo;
import net.bluemind.metrics.alerts.api.AlertLevel;
import net.bluemind.metrics.alerts.api.IMonitoringPromise;
import net.bluemind.metrics.alerts.api.gwt.endpoint.MonitoringGwtEndpoint;
import net.bluemind.ui.adminconsole.monitoring.l10n.ScreensConstants;
import net.bluemind.ui.common.client.forms.Ajax;

public class GlobalStatusScreen
extends Composite
implements IGwtScreenRoot {
    public ScreensConstants text;
    public static final String TYPE = "bm.ac.GlobalStatusScreen";
    private ScreenRoot screenRoot;
    private final Style s;
    @UiField
    FlexTable alertList;
    @UiField
    ListBox levelSelect;
    @UiField
    Label filterLabel;
    @UiField
    ListBox limitSelect;
    @UiField
    Label limitLabel;
    @UiField
    Label selectLabel;
    @UiField
    CheckBox filterResolved;
    private static GlobalStatusScreenBinder uiBinder = (GlobalStatusScreenBinder)GWT.create(GlobalStatusScreenBinder.class);
    private static final Resources res = (Resources)GWT.create(Resources.class);

    private GlobalStatusScreen(ScreenRoot screenRoot) {
        this.screenRoot = screenRoot;
        this.s = res.editStyle();
        this.s.ensureInjected();
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        hTMLPanel.setHeight("100%");
        this.initWidget((Widget)hTMLPanel);
        this.text = (ScreensConstants)GWT.create(ScreensConstants.class);
        this.filterLabel.setText(this.text.filterResolved());
        this.selectLabel.setText(this.text.level());
        this.levelSelect.addItem(this.text.all());
        this.levelSelect.addItem(this.text.warning());
        this.levelSelect.addItem(this.text.critical());
        this.limitSelect.addItem("30");
        this.limitSelect.addItem("60");
        this.limitSelect.addItem("90");
        this.limitSelect.setStyleName(this.s.selectList());
        this.limitLabel.setText(this.text.days());
        this.alertList.setStyleName(this.s.container());
        this.levelSelect.setStyleName(this.s.selectList());
        this.levelSelect.addChangeHandler(changeEvent -> this.refresh());
        this.limitSelect.addChangeHandler(changeEvent -> this.refresh());
        this.filterResolved.addValueChangeHandler(valueChangeEvent -> this.refresh());
    }

    private void refresh() {
        int n = this.levelSelect.getSelectedIndex();
        int n2 = Integer.parseInt(this.limitSelect.getSelectedItemText());
        switch (n) {
            case -1: 
            case 0: {
                this.loadAlerts(this.filterResolved.getValue(), n2, Arrays.asList(AlertLevel.OK, AlertLevel.WARNING, AlertLevel.CRITICAL));
                break;
            }
            case 1: {
                this.loadAlerts(this.filterResolved.getValue(), n2, Arrays.asList(AlertLevel.WARNING));
                break;
            }
            case 2: {
                this.loadAlerts(this.filterResolved.getValue(), n2, Arrays.asList(AlertLevel.CRITICAL));
            }
        }
    }

    public static void registerType() {
        GwtScreenRoot.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtScreenRoot, ScreenRoot>(){

            public IGwtScreenRoot create(ScreenRoot screenRoot) {
                return new GlobalStatusScreen(screenRoot, null);
            }
        });
    }

    public void attach(Element element) {
        element.appendChild((Node)this.getElement());
        this.onAttach();
    }

    public void doLoad(final ScreenRoot screenRoot) {
        screenRoot.load((AsyncHandler)new DefaultAsyncHandler<Void>(){

            public void success(Void void_) {
                screenRoot.loadModel(screenRoot.getModel());
            }
        });
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        this.filterResolved.setValue(Boolean.valueOf(true));
        this.loadAlerts(true, 30, Arrays.asList(AlertLevel.OK, AlertLevel.WARNING, AlertLevel.CRITICAL));
    }

    private void loadAlerts(boolean bl, int n, List<AlertLevel> list2) {
        this.alertList.removeAllRows();
        int n2 = 0;
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.date()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.product()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.id()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.level()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.name()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.host()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.datalocation()));
        this.alertList.setWidget(0, n2++, (Widget)new Label(this.text.message()));
        this.alertList.getRowFormatter().setStyleName(0, this.s.header());
        IMonitoringPromise iMonitoringPromise = new MonitoringGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[0]).promiseApi();
        iMonitoringPromise.getAlerts(n, bl, list2).thenAccept(list -> {
            int n = 0;
            while (n < list.size()) {
                int n2 = 0;
                AlertInfo alertInfo = (AlertInfo)list.get(n);
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.time.iso8601));
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.product));
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.id));
                Label label = new Label();
                label.setStyleName(this.alertToStyle(alertInfo.level));
                this.alertList.setWidget(n + 1, n2++, (Widget)label);
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.name));
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.host));
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.datalocation));
                this.alertList.setWidget(n + 1, n2++, (Widget)new Label(alertInfo.message));
                this.alertList.getRowFormatter().setStylePrimaryName(n + 1, this.s.row());
                ++n;
            }
        });
    }

    private String alertToStyle(AlertLevel alertLevel) {
        switch (alertLevel) {
            case OK: {
                return "fa fa-lg fa fa-circle green";
            }
            case WARNING: {
                return "fa fa-lg fa-warning";
            }
            case CRITICAL: {
                return "fa fa-lg fa fa-circle red";
            }
        }
        return "fa fa-lg fa fa-circle blue";
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
    }

    /* synthetic */ GlobalStatusScreen(ScreenRoot screenRoot, GlobalStatusScreen globalStatusScreen) {
        this(screenRoot);
    }

    static interface GlobalStatusScreenBinder
    extends UiBinder<HTMLPanel, GlobalStatusScreen> {
    }

    public static interface Resources
    extends ClientBundle {
        @ClientBundle.Source(value={"GlobalStatusScreen.css"})
        public Style editStyle();
    }

    public static interface Style
    extends CssResource {
        public String container();

        public String header();

        public String row();

        public String inactive();

        public String icon();

        public String partnership();

        public String action();

        public String refreshList();

        public String selectList();
    }
}

