/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.admin.server;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpServerFileUpload;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonObject;
import java.util.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUploadHandler
implements Handler<HttpServerRequest> {
    Logger logger = LoggerFactory.getLogger(FileUploadHandler.class);

    public void handle(final HttpServerRequest httpServerRequest) {
        httpServerRequest.setExpectMultipart(true);
        httpServerRequest.uploadHandler((Handler)new Handler<HttpServerFileUpload>(){

            public void handle(HttpServerFileUpload httpServerFileUpload) {
                final Buffer buffer = Buffer.buffer();
                final String string = httpServerFileUpload.filename();
                FileUploadHandler.this.logger.info("Handling file-upload. filename: {}", (Object)string.toString());
                httpServerFileUpload.handler((Handler)new Handler<Buffer>(){

                    public void handle(Buffer buffer2) {
                        buffer.appendBuffer(buffer2);
                    }
                });
                httpServerFileUpload.endHandler((Handler)new Handler<Void>(){

                    public void handle(Void void_) {
                        JsonObject jsonObject = new JsonObject();
                        jsonObject.put("filename", (Object)string);
                        jsonObject.put("data", (Object)this.getBase64Content(buffer));
                        (this).FileUploadHandler.this.logger.info("Sending file-upload response for filename {}", (Object)string);
                        HttpServerResponse httpServerResponse = httpServerRequest.response();
                        httpServerResponse.putHeader("Content-Type", "application/json");
                        httpServerResponse.setStatusCode(200);
                        httpServerResponse.end(jsonObject.toString());
                    }

                    private String getBase64Content(Buffer buffer2) {
                        return Base64.getEncoder().encodeToString(buffer2.getBytes());
                    }
                });
            }
        });
    }
}

