/*
 * Decompiled with CFR 0.152.
 */
package net.bluemind.ui.adminconsole.videoconferencing.teams;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.uibinder.client.UiHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.HTMLPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import net.bluemind.core.commons.gwt.JsMapStringJsObject;
import net.bluemind.core.container.api.IContainerManagementPromise;
import net.bluemind.core.container.api.gwt.endpoint.ContainerManagementGwtEndpoint;
import net.bluemind.gwtconsoleapp.base.editor.Ajax;
import net.bluemind.gwtconsoleapp.base.editor.WidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.CompositeGwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.GwtWidgetElement;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtDelegateFactory;
import net.bluemind.gwtconsoleapp.base.editor.gwt.IGwtWidgetElement;
import net.bluemind.resource.api.IResourcesPromise;
import net.bluemind.resource.api.ResourceDescriptor;
import net.bluemind.resource.api.gwt.endpoint.ResourcesGwtEndpoint;
import net.bluemind.ui.adminconsole.videoconferencing.teams.l10n.TeamsConstants;
import net.bluemind.ui.common.client.forms.tag.UUID;
import net.bluemind.videoconferencing.api.IVideoConferencingPromise;
import net.bluemind.videoconferencing.api.VideoConferencingResourceDescriptor;
import net.bluemind.videoconferencing.api.gwt.endpoint.VideoConferencingGwtEndpoint;

public class TeamsEditor
extends CompositeGwtWidgetElement {
    static final String TYPE = "bm.ac.TeamsEditor";
    private static final String PROVIDER_NAME = "Teams";
    private static final String PROVIDER_TYPE = "videoconferencing-teams";
    private static final String SETTINGS_CLIENT_ID = "clientId";
    private static final String SETTINGS_SECRET = "secret";
    private static final String SETTINGS_TENANT = "tenant";
    private static TeamsUiBinder uiBinder = (TeamsUiBinder)GWT.create(TeamsUiBinder.class);
    @UiField
    TextBox clientId;
    @UiField
    TextBox secret;
    @UiField
    TextBox tenant;
    @UiField
    Button deleteBtn;
    private String domainUid;
    private String resourceUid;

    @UiHandler(value={"deleteBtn"})
    void deleteClick(ClickEvent clickEvent) {
        if (Window.confirm((String)TeamsConstants.INST.deleteBtnConfirm())) {
            this.removeResource();
        }
    }

    protected TeamsEditor() {
        HTMLPanel hTMLPanel = (HTMLPanel)uiBinder.createAndBindUi((Object)this);
        this.initWidget((Widget)hTMLPanel);
    }

    public static void registerType() {
        GwtWidgetElement.register((String)TYPE, (IGwtDelegateFactory)new IGwtDelegateFactory<IGwtWidgetElement, WidgetElement>(){

            public IGwtWidgetElement create(WidgetElement widgetElement) {
                return new TeamsEditor();
            }
        });
    }

    public void loadModel(JavaScriptObject javaScriptObject) {
        super.loadModel(javaScriptObject);
        JsMapStringJsObject jsMapStringJsObject = (JsMapStringJsObject)javaScriptObject.cast();
        this.domainUid = jsMapStringJsObject.getString("domainUid");
        IResourcesPromise iResourcesPromise = new ResourcesGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        iResourcesPromise.byType("bm-videoconferencing").thenAccept(list -> {
            if (list != null && !list.isEmpty()) {
                list.forEach(string -> iResourcesPromise.get(string).thenAccept(resourceDescriptor -> {
                    boolean bl = false;
                    int n = 0;
                    while (n < resourceDescriptor.properties.size()) {
                        ResourceDescriptor.PropertyValue propertyValue = (ResourceDescriptor.PropertyValue)resourceDescriptor.properties.get(n);
                        if ("bm-videoconferencing-type".equals(propertyValue.propertyId) && PROVIDER_TYPE.equals(propertyValue.value)) {
                            bl = true;
                        }
                        ++n;
                    }
                    if (bl) {
                        this.resourceUid = string;
                        IContainerManagementPromise iContainerManagementPromise = new ContainerManagementGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.getResourceSettingsContainer(this.resourceUid)}).promiseApi();
                        iContainerManagementPromise.getSettings().thenAccept(map -> {
                            String string;
                            String string2;
                            String string3 = (String)map.get(SETTINGS_CLIENT_ID);
                            if (string3 != null) {
                                this.clientId.setValue((Object)string3);
                            }
                            if ((string2 = (String)map.get(SETTINGS_SECRET)) != null) {
                                this.secret.setValue((Object)string2);
                            }
                            if ((string = (String)map.get(SETTINGS_TENANT)) != null) {
                                this.tenant.setValue((Object)string);
                            }
                        });
                    }
                }));
            }
        });
    }

    public void saveModel(JavaScriptObject javaScriptObject) {
        String string = (String)this.clientId.asEditor().getValue();
        String string2 = (String)this.secret.asEditor().getValue();
        String string3 = (String)this.tenant.asEditor().getValue();
        if (string != null && string2 != null && string3 != null) {
            if (this.resourceUid != null) {
                this.setResourceSettings(this.resourceUid);
            } else {
                String string4 = UUID.uuid();
                this.createResource(string4).thenAccept(void_ -> this.setResourceSettings(string4));
            }
        } else {
            this.removeResource();
        }
    }

    private CompletableFuture<Void> createResource(String string) {
        IVideoConferencingPromise iVideoConferencingPromise = new VideoConferencingGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        return iVideoConferencingPromise.createResource(string, VideoConferencingResourceDescriptor.create((String)PROVIDER_NAME, (String)PROVIDER_TYPE, Collections.emptyList()));
    }

    private void setResourceSettings(String string) {
        IContainerManagementPromise iContainerManagementPromise = new ContainerManagementGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.getResourceSettingsContainer(string)}).promiseApi();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = (String)this.clientId.asEditor().getValue();
        String string3 = (String)this.secret.asEditor().getValue();
        String string4 = (String)this.tenant.asEditor().getValue();
        hashMap.put(SETTINGS_CLIENT_ID, string2);
        hashMap.put(SETTINGS_SECRET, string3);
        hashMap.put(SETTINGS_TENANT, string4);
        iContainerManagementPromise.setSettings(hashMap);
    }

    private void removeResource() {
        IResourcesPromise iResourcesPromise = new ResourcesGwtEndpoint(Ajax.TOKEN.getSessionId(), new String[]{this.domainUid}).promiseApi();
        iResourcesPromise.delete(this.resourceUid).thenAccept(taskRef -> {
            this.clientId.asEditor().setValue(null);
            this.secret.asEditor().setValue(null);
            this.tenant.asEditor().setValue(null);
        });
    }

    private String getResourceSettingsContainer(String string) {
        return String.valueOf(string) + "-settings-container";
    }

    static interface TeamsUiBinder
    extends UiBinder<HTMLPanel, TeamsEditor> {
    }
}

