/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.jvmti;

import io.sentry.jvmti.Frame;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public final class FrameCache {
    private static Set<String> appPackages = new HashSet<String>();
    private static ThreadLocal<WeakHashMap<Throwable, Frame[]>> cache = new ThreadLocal<WeakHashMap<Throwable, Frame[]>>(){

        @Override
        protected WeakHashMap<Throwable, Frame[]> initialValue() {
            return new WeakHashMap<Throwable, Frame[]>();
        }
    };

    private FrameCache() {
    }

    public static void add(Throwable throwable, Frame[] frames) {
        Map weakMap = cache.get();
        weakMap.put(throwable, frames);
    }

    public static Frame[] get(Throwable throwable) {
        Map weakMap = cache.get();
        return (Frame[])weakMap.get(throwable);
    }

    public static boolean shouldCacheThrowable(Throwable throwable, int numFrames) {
        if (appPackages.isEmpty()) {
            return false;
        }
        Map weakMap = cache.get();
        Frame[] existing = (Frame[])weakMap.get(throwable);
        if (existing != null && numFrames <= existing.length) {
            return false;
        }
        for (StackTraceElement stackTraceElement : throwable.getStackTrace()) {
            for (String appFrame : appPackages) {
                if (!stackTraceElement.getClassName().startsWith(appFrame)) continue;
                return true;
            }
        }
        return false;
    }

    public static void addAppPackage(String newAppPackage) {
        appPackages.add(newAppPackage);
    }

    static void reset() {
        cache.get().clear();
        appPackages.clear();
    }
}

