/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.SentryOptions;
import io.sentry.config.Lookup;
import io.sentry.config.ResourceLoader;
import io.sentry.context.Context;
import io.sentry.event.Breadcrumb;
import io.sentry.event.Event;
import io.sentry.event.EventBuilder;
import io.sentry.event.User;
import io.sentry.util.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Sentry {
    private static final Logger logger = LoggerFactory.getLogger(Sentry.class);
    private static final Object STORED_CLIENT_ACCESS = new Object();
    private static SentryClient storedClient = null;
    @Deprecated
    private static ResourceLoader resourceLoader;

    private Sentry() {
    }

    public static SentryClient init() {
        return Sentry.init((String)null);
    }

    public static SentryClient init(@Nullable SentryClientFactory sentryClientFactory) {
        return Sentry.init(SentryOptions.from(Lookup.getDefault(), null, sentryClientFactory));
    }

    public static SentryClient init(@Nullable String dsn) {
        return Sentry.init(SentryOptions.defaults(dsn));
    }

    public static SentryClient init(@Nullable String dsn, @Nullable SentryClientFactory sentryClientFactory) {
        SentryOptions options = SentryOptions.defaults(dsn);
        options.setSentryClientFactory(sentryClientFactory);
        return Sentry.init(options);
    }

    public static SentryClient init(SentryOptions sentryOptions) {
        resourceLoader = sentryOptions.getResourceLoader();
        SentryClient client = sentryOptions.getSentryClientFactory().createClient(sentryOptions.getDsn());
        Sentry.setStoredClient(client);
        return client;
    }

    public static boolean isInitialized() {
        return storedClient != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SentryClient getStoredClient() {
        Object object = STORED_CLIENT_ACCESS;
        synchronized (object) {
            if (Sentry.isInitialized()) {
                return storedClient;
            }
            Sentry.init(SentryOptions.defaults());
        }
        return storedClient;
    }

    @Deprecated
    public static ResourceLoader getResourceLoader() {
        return resourceLoader;
    }

    public static Context getContext() {
        return Sentry.getStoredClient().getContext();
    }

    public static void clearContext() {
        Sentry.getStoredClient().clearContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setStoredClient(SentryClient client) {
        Object object = STORED_CLIENT_ACCESS;
        synchronized (object) {
            if (Sentry.isInitialized()) {
                logger.warn("Overwriting statically stored SentryClient instance {} with {}.", (Object)storedClient, (Object)client);
            }
            storedClient = client;
        }
    }

    public static void capture(Event event) {
        Sentry.getStoredClient().sendEvent(event);
    }

    public static void capture(Throwable throwable) {
        Sentry.getStoredClient().sendException(throwable);
    }

    public static void capture(String message) {
        Sentry.getStoredClient().sendMessage(message);
    }

    public static void capture(EventBuilder eventBuilder) {
        Sentry.getStoredClient().sendEvent(eventBuilder);
    }

    @Deprecated
    public static void record(Breadcrumb breadcrumb) {
        Sentry.getStoredClient().getContext().recordBreadcrumb(breadcrumb);
    }

    @Deprecated
    public static void setUser(User user) {
        Sentry.getStoredClient().getContext().setUser(user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void close() {
        Object object = STORED_CLIENT_ACCESS;
        synchronized (object) {
            if (!Sentry.isInitialized()) {
                return;
            }
            storedClient.closeConnection();
            storedClient = null;
        }
    }
}

